---
title: Require known IP addresses in site admin area · Cloudflare Web
  Application Firewall (WAF) docs
description: If an attack compromises the administrative area of your website,
  the consequences can be severe. With custom rules, you can protect your site’s
  admin area by blocking requests for access to admin paths that do not come
  from a known IP address.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/site-admin-only-known-ips/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/site-admin-only-known-ips/index.md
---

If an attack compromises the administrative area of your website, the consequences can be severe. With custom rules, you can protect your site’s admin area by blocking requests for access to admin paths that do not come from a known IP address.

This example custom rule limits access to the WordPress admin area, `/wp-admin/`, by blocking requests that do not originate from a specified set of IP addresses:

* **Expression**: `(not ip.src in {10.20.30.40 192.168.1.0/24} and starts_with(lower(http.request.uri.path), "/wp-admin"))`
* **Action**: *Block*

To prevent attackers from successfully using a permutation of `/wp-admin/` such as `/wP-AdMiN/`, the expression uses the [`lower()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lower) transformation function to convert the URI path to lowercase.

## Other resources

* [Use case: Allow traffic from IP addresses in allowlist only](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-ips-in-allowlist/)
