---
title: Markdown · Cloudflare Style Guide
description: This component uses marked to render CommonMark and various other
  Markdown flavours.
lastUpdated: 2025-03-06T20:33:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/markdown/
  md: https://developers.cloudflare.com/style-guide/components/markdown/index.md
---

This component uses [`marked`](https://marked.js.org/) to render [CommonMark and various other Markdown flavours](https://marked.js.org/#specifications).

Warning

This component can not use [MDX](https://mdxjs.com/) or [Astro](https://docs.astro.build/en/guides/markdown-content/) features, such as [optimised images in the assets directory](https://docs.astro.build/en/guides/images/#images-in-mdx-files).

Headings should not be used with this component, as they will not receive an `id`, copyable link or appear in the table of contents.

Code blocks should not be used with this component, as they will not receive syntax highlighting or a copy to clipboard button.

## Example for variables in partials

If you have a variable that needs to be formatted in any special way (for example, it needs to be a URL, an unordered list, or something else), you can wrap the variable with the markdown component in your partial file. For example:

```mdx
<Markdown text={props.foo} />
```

Note that you need to wrap your variable in curly braces, as well as use `text=` or this will not work.

## Multi-line strings

The Markdown component uses the [`dedent`](https://www.npmjs.com/package/dedent) library to remove indentation from multi-line strings.

This is because the [CommonMark spec](https://spec.commonmark.org/0.22/#indented-code-blocks) treats indented text as code blocks, unlike [MDX](https://mdxjs.com/docs/what-is-mdx/#:~:text=Indented%20code%20does%20not%20work%20in%20MDX%3A).
