---
title: Cloudflare and CVE-2019-1559 · Cloudflare SSL/TLS docs
description: The GOLDENDOODLE and Zombie POODLE attacks affect applications that
  use certain cipher suites associated with TLS 1.2.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/reference/cloudflare-and-cve-2019-1559/
  md: https://developers.cloudflare.com/ssl/reference/cloudflare-and-cve-2019-1559/index.md
---

The [GOLDENDOODLE and Zombie POODLE attacks](https://www.tripwire.com/state-of-security/vulnerability-management/zombie-poodle-goldendoodle/) affect applications that use certain cipher suites associated with TLS 1.2.

Any application on Cloudflare, however, is not vulnerable to these attacks because Cloudflare does not use the affected version of openssl at its edge.

Cloudflare could not remove these cipher suites from our edge by default because we did not want to break customer applications using legacy cipher suites.

## Remove warnings from external security scanners

Even though your application is not vulnerable to CVE-2019-1559, some security scanners may flag your application erroneously.

To remove these warnings, refer to [Customize cipher suites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/customize-cipher-suites/) and exclude the following ciphers:

* `ECDHE-ECDSA-AES256-SHA384`
* `ECDHE-ECDSA-AES128-SHA256`
* `ECDHE-RSA-AES256-SHA384`
