---
title: Work with managed rulesets · Cloudflare Ruleset Engine docs
description: Managed rulesets are preconfigured rulesets provided by Cloudflare
  that you can deploy. Only Cloudflare can modify these rulesets.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/managed-rulesets/
  md: https://developers.cloudflare.com/ruleset-engine/managed-rulesets/index.md
---

Managed rulesets are preconfigured rulesets provided by Cloudflare that you can deploy. Only Cloudflare can modify these rulesets.

The rules in a managed ruleset have a default configuration. However, you can define [overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) that change this default configuration.

Several Cloudflare products include managed rulesets:

* [Web Application Firewall (WAF)](https://developers.cloudflare.com/waf/managed-rules/)
* [DDoS Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/)
* [Magic Firewall](https://developers.cloudflare.com/magic-firewall/how-to/enable-managed-rulesets/)

Check each product's documentation for details on the available managed rulesets.

## Get started

To view available managed rulesets, refer to [View rulesets](https://developers.cloudflare.com/ruleset-engine/basic-operations/view-rulesets/).

To deploy a managed ruleset to a phase, refer to [Deploy a managed ruleset](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/deploy-managed-ruleset/).

To adjust the behavior of a managed ruleset, do one of the following:

* Customize the behavior of one or more rules by using [overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/).
* Skip one or more managed rules by adding [exceptions](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/create-exception/).

Exceptions (only supported by the WAF) have priority over overrides.
