---
title: Remove locale from URL path · Cloudflare Rules docs
description: Create a redirect rule to redirect visitors from an old URL format
  with locale information to a new URL format.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/remove-locale-url/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/remove-locale-url/index.md
---

This example single redirect for zone `example.com` will redirect visitors from an old URL format that included the locale (for example, `/en-us/<page_name>`) to the new format `/<page_name>`.

**When incoming requests match**

* **Field:** *URI Path*
* **Operator:** *matches regex*
* **Value:** `^/[A-Za-z]{2}-[A-Za-z]{2}/`

If you are using the Expression Editor, enter the following expression:\
`http.request.uri.path matches "^/[A-Za-z]{2}-[A-Za-z]{2}/"`

**Then**

* **Type:** *Dynamic*
* **Expression:** `regex_replace(http.request.uri.path, "^/[A-Za-z]{2}-[A-Za-z]{2}/(.*)", "/${1}")`
* **Status code:** *301*
* **Preserve query string:** Enabled

The function [`regex_replace()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#regex_replace) allows you to extract parts of the URL using regular expressions' capture groups. Create capture groups by putting part of the regular expression in parentheses. Then, reference a capture group using `${<num>}` in the replacement string, where `<num>` is the number of the capture group.

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `example.com/en-us/meet-our-team` | `example.com/meet-our-team` | `301` |
| `example.com/pt-BR/meet-our-team` | `example.com/meet-our-team` | `301` |
| `example.com/en-us/calendar?view=month` | `example.com/calendar?view=month` | `301` |
| `example.com/meet-our-team` | (unchanged) | n/a |
| `example.com/robots.txt` | (unchanged) | n/a |
