---
title: Rewrite path of moved section of a website · Cloudflare Rules docs
description: Create a URL rewrite rule (part of Transform Rules) to rewrite
  everything under `/blog/<PATH>` to `/marketing/<PATH>`.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/rewrite-moved-section/
  md: https://developers.cloudflare.com/rules/transform/examples/rewrite-moved-section/index.md
---

To rewrite everything under `/blog/<PATH>` to `/marketing/<PATH>`, create a new URL rewrite rule and define a dynamic URL path rewrite using [wildcard pattern parameters](https://developers.cloudflare.com/rules/transform/url-rewrite/create-dashboard/#wildcard-pattern-parameters):

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `https://<YOUR_HOSTNAME>/blog/*`

**Then rewrite the path and/or query**

* **Target path**: \[`/`] `blog/*`
* **Rewrite to**: \[`/`] `marketing/${1}`

Make sure to replace `<YOUR_HOSTNAME>` with your actual hostname and adjust the example paths according to your setup.
