---
title: Add a request header with the current bot score · Cloudflare Rules docs
description: Create a request header transform rule to add a `X-Bot-Score` HTTP
  header to the request with the current bot score.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Request modification
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/add-request-header-bot-score/
  md: https://developers.cloudflare.com/rules/transform/examples/add-request-header-bot-score/index.md
---

The following request header transform rule adds a header named `X-Bot-Score` with the current bot score to the HTTP request:

Text in **Expression Editor**:

```txt
starts_with(http.request.uri.path, "/en/")
```

Selected operation under **Modify request header**: *Set dynamic*

**Header name**: `X-Bot-Score`

**Value**: `to_string(cf.bot_management.score)`
