---
title: Cryptographic Background · Cloudflare Randomness Beacon docs
description: drand is an efficient randomness beacon daemon that utilizes
  pairing-based cryptography, 𝑡-of-𝑛 distributed key generation, and threshold
  BLS signatures to generate publicly-verifiable, unbiasable, unpredictable,
  distributed randomness.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/randomness-beacon/cryptographic-background/
  md: https://developers.cloudflare.com/randomness-beacon/cryptographic-background/index.md
---

drand is an efficient randomness beacon daemon that utilizes pairing-based cryptography, `𝑡-of-𝑛` distributed key generation, and threshold BLS signatures to generate publicly-verifiable, unbiasable, unpredictable, distributed randomness.

This is an overview of the cryptographic building blocks drand uses to generate publicly-verifiable, unbiasable, and unpredictable randomness in a distributed manner.

The drand beacon has two phases: a setup phase and a beacon phase. Generally, we assume that there are *n* participants, out of which at most *f\<n* are malicious. drand relies heavily on threshold cryptography primitives, where (at minimum) a threshold of *t-f+1* nodes work together to successfully execute cryptographic operations.

Threshold cryptography has many applications as it avoids single points of failure. One application is cryptocurrency multi-sig wallets, where *t-of-n* participants are required to sign a transaction using a threshold signature scheme.

Note

This document is intended for a general audience. No cryptographic background knowledge is required to understand these concepts.
