---
title: Zero Trust logs · Cloudflare One docs
description: Review detailed logs for your Zero Trust organization.
lastUpdated: 2025-06-23T13:26:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/insights/logs/
  md: https://developers.cloudflare.com/cloudflare-one/insights/logs/index.md
---

Review detailed logs for your Zero Trust organization.

* [Access audit logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/audit-logs/)
* [Enable Email security logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/)
* [Filter different views](https://developers.cloudflare.com/cloudflare-one/insights/logs/filter-views/)
* [SCIM activity logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/)
* [Use Logpush with IDS](https://developers.cloudflare.com/cloudflare-one/insights/logs/use-logpush-with-ids/)
* [Gateway activity logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/)
* [Tunnel audit logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/tunnel-audit-logs/)
* [Posture logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/posture-logs/)
* [Logpush integration](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/)

## Log retention

Cloudflare Zero Trust logs are stored for a varying period of time based on the service used and plan type:

| | Free | Standard | Access | Gateway | Enterprise |
| - | - | - | - | - | - |
| **Admin logs** | 18 months | 18 months | 18 months | 18 months | 18 months |
| **Access logs** | 24 hours | 30 days | 30 days | 24 hours | 180 days |
| **DNS logs** | 24 hours | 30 days | 24 hours | 30 days | 180 days[1](#user-content-fn-1) |
| **Network logs** | 24 hours | 30 days | 24 hours | 30 days | 30 days |
| **HTTP logs** | 24 hours | 30 days | 24 hours | 30 days | 30 days |
| **DEX logs** | 7 days | 7 days | 7 days | 7 days | 7 days |
| **Device posture logs** | 30 days | 30 days | 30 days | 30 days | 30 days |

## Log Explorer Beta

Log Explorer users can store Zero Trust logs directly within Cloudflare in an [R2 bucket](https://developers.cloudflare.com/r2/) and access them with the dashboard or API. Log Explorer supports the following Zero Trust datasets:

* [Access requests](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/access_requests/) (`FROM access_requests`)
* [CASB Findings](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/casb_findings/) (`FROM casb_findings`)
* [Device posture results](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/device_posture_results/) (`FROM device_posture_results`)
* [Gateway DNS](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_dns/) (`FROM gateway_dns`)
* [Gateway HTTP](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_http/) (`FROM gateway_http`)
* [Gateway Network](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/gateway_network/) (`FROM gateway_network`)
* [Zero Trust Network Session Logs](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/) (`FROM zero_trust_network_sessions`)

For more information, refer to [Log Explorer](https://developers.cloudflare.com/log-explorer/).

## Customer Metadata Boundary

Cloudflare Zero Trust can be used with the Data Localization Suite to ensure that data storage is restricted to a specific geographic region. For more information refer to [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/).

## Data privacy

For more information on how we use this data, refer to our [Privacy Policy](https://www.cloudflare.com/application/privacypolicy/).

## Footnotes

1. Enterprise users on per query plans cannot store DNS logs via Cloudflare. You can still export logs via [Logpush](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/). For more information, contact your account team. [↩](#user-content-fnref-1)
