---
title: Preview URLs now default to opt-in · Changelog
description: We performed a one-time update to disable preview URLs on Workers
  with workers.dev disabled to require an explicit opt-in.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-17-update-preview-url-setting/
  md: https://developers.cloudflare.com/changelog/2025-09-17-update-preview-url-setting/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Preview URLs now default to opt-in

Sep 17, 2025

[Workers](https://developers.cloudflare.com/workers/)

To prevent the accidental exposure of applications, we've updated how [Worker preview URLs](https://developers.cloudflare.com/workers/configuration/previews/) (`<PREVIEW>-<WORKER_NAME>.<SUBDOMAIN>.workers.dev`) are handled. We made this change to ensure preview URLs are only active when intentionally configured, improving the default security posture of your Workers.

#### One-Time Update for Workers with workers.dev Disabled

We performed a one-time update to disable preview URLs for existing Workers where the [workers.dev subdomain](https://developers.cloudflare.com/workers/configuration/routing/workers-dev/) was also disabled.

Because preview URLs were historically enabled by default, users who had intentionally disabled their workers.dev route may not have realized their Worker was still accessible at a separate preview URL. This update was performed to ensure that using a preview URL is always an intentional, opt-in choice.

If your Worker was affected, its preview URL (`<PREVIEW>-<WORKER_NAME>.<SUBDOMAIN>.workers.dev`) will now direct to an informational page explaining this change.

**How to Re-enable Your Preview URL**

If your preview URL was disabled, you can re-enable it [via the Cloudflare dashboard](https://developers.cloudflare.com/workers/configuration/previews/#toggle-preview-urls-enable-or-disable) by navigating to your Worker's Settings page and toggling on the Preview URL.

Alternatively, you can use Wrangler by adding the `preview_urls = true` setting to your Wrangler file and redeploying the Worker.

* wrangler.jsonc

  ```jsonc
  {
    "preview_urls": true
  }
  ```

* wrangler.toml

  ```toml
  preview_urls = true
  ```

**Note:** You can set `preview_urls = true` with any Wrangler version that supports the preview URL flag (v3.91.0+). However, we recommend updating to v4.34.0 or newer, as this version defaults `preview_urls` to false, ensuring preview URLs are always enabled by explicit choice.
